// DEMODlg.cpp : implementation file
//

#include "stdafx.h"
#include "DEMO.h"
#include "DEMODlg.h"
#include "CtrlCard.h"

#include "adt856.h"

#include "BaseParaSet.h"
#include "IOTest.h"

CCtrlCard	g_CtrlCard;

//#define RUNNING 1;

int g_WorkStatus=0;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDEMODlg dialog

CDEMODlg::CDEMODlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDEMODlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDEMODlg)
	m_nAddW = 0;
	m_nAddX = 0;
	m_nAddY = 0;
	m_nAddZ = 0;
	m_bW = FALSE;
	m_bX = FALSE;
	m_bY = FALSE;
	m_bZ = FALSE;
	m_nPulseW = 0;
	m_nPulseX = 0;
	m_nPulseY = 0;
	m_nPulseZ = 0;
	m_nRatioW = 0;
	m_nRatioX = 0;
	m_nRatioY = 0;
	m_nRatioZ = 0;
	m_nSpeedW = 0;
	m_nSpeedX = 0;
	m_nSpeedY = 0;
	m_nSpeedZ = 0;
	m_nStartvW = 0;
	m_nStartvX = 0;
	m_nStartvY = 0;
	m_nStartvZ = 0;
	m_nAddMode = 0;
	m_nDecX = 0;
	m_nDecY = 0;
	m_nDecZ = 0;
	m_nDecW = 0;
	m_nAddU = 0;
	m_nAddV = 0;
	m_bV = FALSE;
	m_bU = FALSE;
	m_nDecV = 0;
	m_nDecU = 0;
	m_nPulseV = 0;
	m_nPulseU = 0;
	m_nRatioV = 0;
	m_nRatioU = 0;
	m_nSpeedV = 0;
	m_nSpeedU = 0;
	m_nStartvV = 0;
	m_nStartvU = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDEMODlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDEMODlg)
	DDX_Control(pDX, IDC_STOPDATA_U, m_nStopData_u);
	DDX_Control(pDX, IDC_STOPDATA_V, m_nStopData_v);
	DDX_Control(pDX, IDC_STOPDATA_W, m_nStopData_w);
	DDX_Control(pDX, IDC_STOPDATA_Z, m_nStopData_z);
	DDX_Control(pDX, IDC_STOPDATA_Y, m_nStopData_y);
	DDX_Control(pDX, IDC_STOPDATA_X, m_nStopData_x);
	DDX_Text(pDX, IDC_ADD_W, m_nAddW);
	DDX_Text(pDX, IDC_ADD_X, m_nAddX);
	DDX_Text(pDX, IDC_ADD_Y, m_nAddY);
	DDX_Text(pDX, IDC_ADD_Z, m_nAddZ);
	DDX_Check(pDX, IDC_CHECK_W, m_bW);
	DDX_Check(pDX, IDC_CHECK_X, m_bX);
	DDX_Check(pDX, IDC_CHECK_Y, m_bY);
	DDX_Check(pDX, IDC_CHECK_Z, m_bZ);
	DDX_Text(pDX, IDC_PULSE_W, m_nPulseW);
	DDX_Text(pDX, IDC_PULSE_X, m_nPulseX);
	DDX_Text(pDX, IDC_PULSE_Y, m_nPulseY);
	DDX_Text(pDX, IDC_PULSE_Z, m_nPulseZ);
	DDX_Text(pDX, IDC_RATIO_W, m_nRatioW);
	DDX_Text(pDX, IDC_RATIO_X, m_nRatioX);
	DDX_Text(pDX, IDC_RATIO_Y, m_nRatioY);
	DDX_Text(pDX, IDC_RATIO_Z, m_nRatioZ);
	DDX_Text(pDX, IDC_SPEED_W, m_nSpeedW);
	DDX_Text(pDX, IDC_SPEED_X, m_nSpeedX);
	DDX_Text(pDX, IDC_SPEED_Y, m_nSpeedY);
	DDX_Text(pDX, IDC_SPEED_Z, m_nSpeedZ);
	DDX_Text(pDX, IDC_STARTV_W, m_nStartvW);
	DDX_Text(pDX, IDC_STARTV_X, m_nStartvX);
	DDX_Text(pDX, IDC_STARTV_Y, m_nStartvY);
	DDX_Text(pDX, IDC_STARTV_Z, m_nStartvZ);
	DDX_Radio(pDX, IDC_CHECK_TMOVE_TYPE, m_nAddMode);
	DDX_Text(pDX, IDC_DEC_X, m_nDecX);
	DDX_Text(pDX, IDC_DEC_Y, m_nDecY);
	DDX_Text(pDX, IDC_DEC_Z, m_nDecZ);
	DDX_Text(pDX, IDC_DEC_W, m_nDecW);
	DDX_Text(pDX, IDC_ADD_U, m_nAddU);
	DDX_Text(pDX, IDC_ADD_V, m_nAddV);
	DDX_Check(pDX, IDC_CHECK_V, m_bV);
	DDX_Check(pDX, IDC_CHECK_U, m_bU);
	DDX_Text(pDX, IDC_DEC_V, m_nDecV);
	DDX_Text(pDX, IDC_DEC_U, m_nDecU);
	DDX_Text(pDX, IDC_PULSE_V, m_nPulseV);
	DDX_Text(pDX, IDC_PULSE_U, m_nPulseU);
	DDX_Text(pDX, IDC_RATIO_V, m_nRatioV);
	DDX_Text(pDX, IDC_RATIO_U, m_nRatioU);
	DDX_Text(pDX, IDC_SPEED_V, m_nSpeedV);
	DDX_Text(pDX, IDC_SPEED_U, m_nSpeedU);
	DDX_Text(pDX, IDC_STARTV_V, m_nStartvV);
	DDX_Text(pDX, IDC_STARTV_U, m_nStartvU);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDEMODlg, CDialog)
	//{{AFX_MSG_MAP(CDEMODlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_PMOVE, OnButtonPmove)
	ON_BN_CLICKED(IDC_BUTTON_INPMOVE, OnButtonInpmove)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_BN_CLICKED(IDC_BUTTON_IOTEST, OnButtonIotest)
	ON_BN_CLICKED(IDC_BUTTON_BASEPARA, OnButtonBasepara)
	ON_BN_CLICKED(IDC_BUTTON_CLEARPOS, OnButtonClearpos)
	ON_BN_CLICKED(IDC_ARC_INP, OnArcInp)
	ON_BN_CLICKED(IDC_CONTINUE_INP, OnContinueInp)
	ON_BN_CLICKED(IDC_BUTTON_CMOVE, OnButtonCmove)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDEMODlg message handlers

BOOL CDEMODlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// Add "About..." menu item to system menu.
	
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);
	
	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}
	
	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	CWnd   *wnd;            //Set Font ( 20: big and small)    	
	pFont.CreateFont(20,0,0,0,600,FALSE,FALSE,0,ANSI_CHARSET,OUT_STROKE_PRECIS, CLIP_STROKE_PRECIS,DEFAULT_QUALITY,VARIABLE_PITCH|FF_SWISS,_T(""));   
    wnd=(CWnd*)GetDlgItem(IDC_STATIC_TITLE);
	wnd->SetFont(&pFont); 

	
	// TODO: Add extra initialization here
	
	//*************initial adt856 motion-card**************
	if (g_CtrlCard.Init_Board() <= 0)
	{		
        MessageBox( "Fail to initial motion-card!");				
	}                
    else
		
		MessageBox ("Succeed in initial motion-card!");
	
	//******* set start-speed 100	*********
	m_nStartvX = 100;
	m_nStartvY = 100;
	m_nStartvZ = 100;
	m_nStartvW = 100;
	m_nStartvU = 100;
	m_nStartvV = 100;
	//*********set run-speed 200********
	m_nSpeedX  = 200; 
	m_nSpeedY  = 200; 
	m_nSpeedZ  = 200; 
	m_nSpeedW  = 200; 
	m_nSpeedU  = 200; 
	m_nSpeedV  = 200; 
	//*********set add 125**********
	m_nAddX    = 625;
	m_nAddY    = 625;
	m_nAddZ    = 625;
	m_nAddW    = 625;
	m_nAddU    = 625;
	m_nAddV    = 625;

	//*********set ratio 5**************
    m_nRatioX  = 5;
	m_nRatioY  = 5;
	m_nRatioZ  = 5;
	m_nRatioW  = 5;
	m_nRatioU  = 5;
	m_nRatioV  = 5;
	//********set pulse 10000******
	m_nPulseX  = 10000;
	m_nPulseY  = 10000;
	m_nPulseZ  = 10000;
	m_nPulseW  = 10000;
	m_nPulseU  = 10000;
	m_nPulseV  = 10000;

	/************set dec 25****************/
    m_nDecW=625;
	m_nDecX=625;
	m_nDecY=625;
	m_nDecZ=625;
	m_nDecU=625;
	m_nDecV=625;

	
    UpdateData(FALSE);
	
	SetTimer(MAINTIMER,100,NULL);        //begin timer
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDEMODlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDEMODlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDEMODlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


/**********************************************************

OnButtonPmove() :axis move

**********************************************************/
void CDEMODlg::OnButtonPmove() 
{
	UpdateData(TRUE);
	
	long Startv[]={m_nStartvX,m_nStartvY,m_nStartvZ,m_nStartvW,m_nStartvU,m_nStartvV};  //start-speed
	
	long Speed[]={m_nSpeedX,m_nSpeedY,m_nSpeedZ,m_nSpeedW,m_nSpeedU,m_nSpeedV};        //run-speed
	
	long Dec[]=	{m_nDecX,m_nDecY,m_nDecZ,m_nDecW,m_nDecU,m_nDecV };                    //dec
	
	long Add[]  ={m_nAddX,m_nAddY,m_nAddZ,m_nAddW,m_nAddU,m_nAddV};                    //acc
	
	long Ratio[]={m_nRatioX,m_nRatioY,m_nRatioZ,m_nRatioW,m_nRatioU,m_nRatioV};        //ratio
	

	//**************X axis move********************//
	if(m_bX ) 
	{		
		//*************set speed*******************//
		g_CtrlCard.Setup_Speed(1, m_nStartvX, m_nSpeedX, m_nAddX, m_nDecX, m_nRatioX, m_nAddMode);

		g_CtrlCard.Axis_Pmove(1, m_nPulseX);		
	}
	//**************Y axis move********************//
	if(m_bY ) 
	{		
		//*************set speed*******************//
		g_CtrlCard.Setup_Speed(2, m_nStartvY, m_nSpeedY, m_nAddY, m_nDecY,m_nRatioY, m_nAddMode);

		g_CtrlCard.Axis_Pmove(2, m_nPulseY);		
	}

	if(m_bZ ) 
	{		
		//*************set speed*******************//
		g_CtrlCard.Setup_Speed(3, m_nStartvZ, m_nSpeedZ, m_nAddZ, m_nDecZ, m_nRatioZ, m_nAddMode);

		g_CtrlCard.Axis_Pmove(3, m_nPulseZ);
	}
	if(m_bW ) 
	{		
		//*************set speed*******************//
		g_CtrlCard.Setup_Speed(4, m_nStartvW, m_nSpeedW, m_nAddW, m_nDecW, m_nRatioW, m_nAddMode);

		g_CtrlCard.Axis_Pmove(4, m_nPulseW);		
	}

	if(m_bU ) 
	{		
		//*************set speed*******************//
		g_CtrlCard.Setup_Speed(5, m_nStartvU, m_nSpeedU, m_nAddU, m_nDecU, m_nRatioU, m_nAddMode);

		g_CtrlCard.Axis_Pmove(5, m_nPulseU);		
	}

	if(m_bV ) 
	{		
		//*************set speed*******************//
		g_CtrlCard.Setup_Speed(6, m_nStartvV, m_nSpeedV, m_nAddV, m_nDecV, m_nRatioV, m_nAddMode);

		g_CtrlCard.Axis_Pmove(6, m_nPulseV);		
	}
	
}
/**********************************************************

  OnButtonInpmove():linear interpolation button   

*********************************************************/
void CDEMODlg::OnButtonInpmove() 
{
	UpdateData();
	
	long Startv[]={m_nStartvX,m_nStartvY,m_nStartvZ,m_nStartvW,m_nStartvU,m_nStartvV};   
	
	long Speed[]={m_nSpeedX,m_nSpeedY,m_nSpeedZ,m_nSpeedW,m_nSpeedU,m_nSpeedV};          
	
	long Add[]  ={m_nAddX,m_nAddY,m_nAddZ,m_nAddW,m_nAddU,m_nAddV};   	               
	
	long Dec[]  ={m_nDecX,m_nDecY,m_nDecZ,m_nDecW,m_nDecU,m_nDecV};                   
	
	long Pulse[]={m_nPulseX,m_nPulseY,m_nPulseZ,m_nPulseW,m_nPulseU,m_nPulseV};         
	
	long Ratio[]={m_nRatioX,m_nRatioY,m_nRatioZ,m_nRatioW,m_nRatioU,m_nRatioV};   

	//*******************interp-move with two axes********************//
	
	if(m_bX && m_bY && !m_bZ && !m_bW && !m_bU && !m_bV)                  //XY
	{
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0], Dec[0], Ratio[0], m_nAddMode);
		
		g_CtrlCard.Interp_Move2(1,  Pulse[0], Pulse[1]);
		
		
	}	
	else if(!m_bX && !m_bY && m_bZ && m_bW && !m_bU && !m_bV)            //ZW
	{
		
		g_CtrlCard.Setup_Speed(3, Startv[2], Speed[2], Add[2], Dec[2],  Ratio[2], m_nAddMode);
		
		g_CtrlCard.Interp_Move2(2, Pulse[2], Pulse[3]);
		
	}
	//*******************interp-move with three axes********************//
	else if(m_bX && m_bY && m_bZ && !m_bW && !m_bU && !m_bV)            //XYZ
	{
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0], Dec[0] , Ratio[0], m_nAddMode);
		
		g_CtrlCard.Setup_Speed(3, Speed[0], Speed[0], Add[2], Dec[2] , Ratio[0], m_nAddMode);
		
		g_CtrlCard.Interp_Move3( Pulse[0], Pulse[1], Pulse[2]);
	}	
	
	//*******************interp-move with four axes********************//
	else if(m_bX && m_bY && m_bZ && m_bW && !m_bU && !m_bV)            //XYZW
	{
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0],  Dec[0] , Ratio[0], m_nAddMode);
		
		g_CtrlCard.Setup_Speed(3, Speed[0], Speed[0], Add[2], Dec[2] , Ratio[0], m_nAddMode);
		
		g_CtrlCard.Interp_Move4(Pulse[0], Pulse[1], Pulse[2], Pulse[3]);
	}
	

	//*******************interp-move with six axes********************//
	else if(m_bX && m_bY && m_bZ && m_bW && m_bU && m_bV)            //XYZWUV
	{
		g_CtrlCard.Setup_Speed(1, Startv[0], Speed[0], Add[0],  Dec[0] , Ratio[0], m_nAddMode);
		
		g_CtrlCard.Setup_Speed(3, Speed[0], Speed[0], Add[2], Dec[2] , Ratio[0], m_nAddMode);

		g_CtrlCard.Setup_Speed(5, Speed[0], Speed[0], Add[4], Dec[4] , Ratio[0], m_nAddMode);
		
		g_CtrlCard.Interp_Move6(Pulse[0], Pulse[1], Pulse[2], Pulse[3],Pulse[4], Pulse[5]);
	}

	else if(!m_bX && !m_bY && !m_bZ && !m_bW && !m_bU && !m_bV) 
	{
		MessageBox("Please choose axis for inp-move!","Notice");
	}
	
	else 
	{
		MessageBox(" wrong axis!","Notice");
	}
	
	
}
/***********************************************************
               stop button
             sudden-stop all axis
***********************************************************/
void CDEMODlg::OnButtonStop() 
{
	for (int i = 1; i<=MAXAXIS; i++)
	{	
		g_CtrlCard.StopRun(i,0);   
    }

	g_WorkStatus=0;
	
}
//********************Get Information*************************//
//    Get logic-pos,real-pos,run-speed,run-status          //
//   Read input signal of LMT+,LMT-,stop0 ,stop1and stop2   //
//*********************************************************//
void CDEMODlg::OnTimer(UINT nIDEvent) 
{

	long log,act,spd;

	int Stopdata[6];

	UINT nID1[]={IDC_POS_LOGX,IDC_POS_LOGY,IDC_POS_LOGZ,IDC_POS_LOGW,IDC_POS_LOGU,IDC_POS_LOGV};

	UINT nID2[]={IDC_POS_ACTX,IDC_POS_ACTY,IDC_POS_ACTZ,IDC_POS_ACTW,IDC_POS_ACTU,IDC_POS_ACTV};

	UINT nID3[]={IDC_RUNSPEED_X,IDC_RUNSPEED_Y,IDC_RUNSPEED_Z,IDC_RUNSPEED_W,IDC_RUNSPEED_U,IDC_RUNSPEED_V};

	UINT nID4[]={m_nRatioX,m_nRatioY,m_nRatioZ,m_nRatioW,m_nRatioU,m_nRatioV};

	UINT nID5[]={IDC_STOPDATA_X, IDC_STOPDATA_Y, IDC_STOPDATA_Z, IDC_STOPDATA_W,IDC_STOPDATA_U, IDC_STOPDATA_V};

	CStatic *lbl;

	CString str,stopinf;

	int status[6];

	for (int i=1; i<MAXAXIS+1; i++)
	{

		g_CtrlCard.Get_CurrentInf(i,log,act,spd);  //Get logic-pos ,actual-pos and run-speed

		//******display logic-pos*********//
		lbl=(CStatic*)GetDlgItem(nID1[i-1]);

		str.Format("%ld",log);

		lbl->SetWindowText(str);                      

		//******display actual-pos*********//
		lbl=(CStatic*)GetDlgItem(nID2[i-1]);

		str.Format("%ld",act);

		lbl->SetWindowText(str);

		//******display run-speed*********//
		lbl=(CStatic*)GetDlgItem(nID3[i-1]);

		str.Format("%ld",spd*nID4[i-1]);

		lbl->SetWindowText(str);

		//******Get status*********//
		g_CtrlCard.Get_Status(i,status[i-1],0);
		

		//******Get error Information*********//
		g_CtrlCard.Get_ErrorInf(i, Stopdata[i-1]);

	   stopinf.Format("%d",Stopdata[i-1]);
	//	stopinf.Format("%d",status[0]);

	 	lbl=(CStatic*)GetDlgItem(nID5[i-1]);

		lbl->SetWindowText(stopinf);

	}
	//TRACE("%d\n",status[0]);
//***********************źż******************************
//           XLMT+ -0               XLMT- 1
//           XSTOP0 -2              XSTOP1 3
//           XSTOP2 4
//           YLMT+ -8               YLMT-  9
//           YSTOP0 -10             YSTOP1 11
//           YSTOP2 12
//           ZLMT+ -16              ZLMT- 17
//           ZSTOP0 -18             ZSTOP1 19
//           ZSTOP1 20
//           WLMT+ -24              WLMT- 25
//           WSTOP0 -26             WSTOP1 27
//           WSTOP2 28
//           LMT+ -32               ULMT- 33
//           USTOP0 -34             USTOP1 35
//           USTOP1 36
//           VLMT+ -40              VLMT- 41
//           VSTOP0 -42             VSTOP1 43
//           VSTOP2 44
//*************************************************************
	UINT nIDIN[]={   IDC_LIMIT_X,IDC_LIMIT_X2,             //XLMT+/XLMT-
					 IDC_STOP0_X,IDC_STOP1_X,     
					 IDC_STOP2_X3,
		             IDC_LIMIT_Y,IDC_LIMIT_Y2,             //YLMT+/YLMT-
					 IDC_STOP0_Y,IDC_STOP1_Y2,
                     IDC_STOP2_Y3,
				     IDC_LIMIT_Z,IDC_LIMIT_Z2,             //ZLMT+/ZLMT-
					 IDC_STOP0_Z,IDC_STOP1_Z,
                     IDC_STOP2_Z2,
					 IDC_LIMIT_W,IDC_LIMIT_W2,             //WLMT+/WLMT-
					 IDC_STOP0_W,IDC_STOP1_W ,
                   	 IDC_STOP2_W2, 
	                 IDC_LIMIT_U,IDC_LIMIT_U2,             //ULMT+/WLMT-
					 IDC_STOP0_U,IDC_STOP1_U,
                     IDC_STOP2_U2,
					 IDC_LIMIT_V,IDC_LIMIT_V2,            //VLMT+/WLMT-
					 IDC_STOP0_V,IDC_STOP1_V ,
                   	 IDC_STOP2_V2  
	}; 
	int io[]={0,1,2,3,4,8,9,10,11,12,16,17,18,19,20,24,25,26,27,28,32,33,34,35,36,40,41,42,43,44};

	CButton *btn;

	int value;

	for (i=0; i<30; i++)
	{
		value=g_CtrlCard.Read_Input(io[i]);                   //read input signal

		btn=(CButton*)GetDlgItem(nIDIN[i]);

		btn->SetCheck(value==0?1:0);
	}
//******************************************************************
	
	
	CDialog::OnTimer(nIDEvent);
}

void CDEMODlg::OnButtonIotest() 
{
	CIOTest dlg;

	dlg.DoModal();
	
}


void CDEMODlg::OnButtonBasepara() 
{
	CBaseParaSet dlg;

	dlg.DoModal();
	
}
/*******************************************
         Clear pos
********************************************/

void CDEMODlg::OnButtonClearpos() 
{
	for(int i=1; i<MAXAXIS+1; i++)
	{
		g_CtrlCard.Setup_Pos(i, 0, 0);    //set logical-pos 0

		g_CtrlCard.Setup_Pos(i, 0, 1);    //set actual-pos  0
	}
	
}
/*********************************************************
  OnArcInp(): circular interpolation button 
  In circular interpolation ,only manual deceleration in inline 
  acceleration/deceleration dring is available,the automatil 
  deceleration in S-curve driving is not available  
*********************************************************/
void CDEMODlg::OnArcInp() 
{
	UpdateData(TRUE);
	
	long startv[]={m_nStartvX,m_nStartvY,m_nStartvZ,m_nStartvW,m_nStartvU,m_nStartvV};
	
	long Speed[]={m_nSpeedX,m_nSpeedY,m_nSpeedZ,m_nSpeedW,m_nSpeedU,m_nSpeedV};		  
	
	long Add[]={m_nAddX,m_nAddY,m_nAddZ,m_nAddW,m_nAddU,m_nAddV};                    
	
	long Dec[]={m_nDecX,m_nDecY,m_nDecZ,m_nDecW,m_nDecU,m_nDecV};                     
	
	long Ratio[]={m_nRatioX,m_nRatioY,m_nRatioZ,m_nRatioW,m_nRatioU,m_nRatioV};     
	
	long Pos[]={m_nPulseX,m_nPulseY,m_nPulseZ,m_nPulseW,m_nPulseU,m_nPulseV};        
	
	long value;

	long double tmpvalue; 
	
    if((m_nAddMode==0)||(m_nAddMode==1))
	{	
		if( m_bX && m_bY && !m_bZ && !m_bW && !m_bU && !m_bV)
		{
			g_CtrlCard.Setup_Speed(1,startv[0],Speed[0],Add[0],Dec[0],Ratio[0],m_nAddMode);			
		
			if(startv[0]<Speed[0]) //acceleration/deceleration action
			{  
				//*****************************************//
				//  0:symmetry acceleration/deceleration  //
				//  1:automatic acceleration/deceleration //
				//****************************************//
				g_CtrlCard.Set_DecMode(1,0,1);
             
				tmpvalue = double(Pos[0])*double(Pos[0])+double(Pos[1])*double(Pos[1]);

				value=long(sqrt(tmpvalue)/1.414)*8;
				
				g_CtrlCard.Set_DecPos(1,value,startv[0],Speed[0],Add[0]);
				
			}
			
			//selected X-Y axis for CCW-circular interpolation
			g_CtrlCard.Interp_Arc(1,0,0,Pos[0],Pos[1]);
		
		}              
		else if(m_bZ && m_bW&&!m_bX&&!m_bY && !m_bU && !m_bV)
		{
			
			g_CtrlCard.Setup_Speed(3,startv[2],Speed[2],Add[2],Dec[2],Ratio[2],m_nAddMode);
			
			if(startv[2]<Speed[2]) //acceleration/deceleration action
			{  
				//***************************************//
				//  0:symmetry acceleration/deceleration     //
				//  1:automatic acceleration/deceleration   //
				//****************************************//
				g_CtrlCard.Set_DecMode(3,0,1);	

				tmpvalue = double(Pos[2])*double(Pos[2])+double(Pos[3])*double(Pos[3]);

				value=long(sqrt(tmpvalue)/1.414)*8;
				
				g_CtrlCard.Set_DecPos(3,value,startv[2],Speed[2],Add[2]);			
				
			}
			//selected Z-W axis for CCW-circular interpolation
			g_CtrlCard.Interp_CcwArc(2,Pos[2]*2,Pos[3]*2,Pos[2],Pos[3]);
		}  
		
		else
		{
			MessageBox("please choose X-Y axes or Z-W axes for arcinp-move!");
		}
		
	} 
	
	else
	{
		MessageBox("canot choose S-curve for add or dec !");
	}
	
}
/*********************************************************

  OnContinueInp(): continuous interpolation button
  
	only manual deceleration in inline acceleration/deceleration dring is available,
	
	  the automatil deceleration in S-curve driving is not available 
*********************************************************/
void CDEMODlg::OnContinueInp() 
{		
	UpdateData(TRUE);	

	int no;    	

	int status1,status2;	

	long startv[]={m_nStartvX,m_nStartvY,m_nStartvZ,m_nStartvW,m_nStartvU,m_nStartvV};	

	long Speed[]={m_nSpeedX,m_nSpeedY,m_nSpeedZ,m_nSpeedW,m_nSpeedU,m_nSpeedV};       
	
	long Dec[]  ={m_nDecX,m_nDecY,m_nDecZ,m_nDecW,m_nDecU,m_nDecV};                   	

	long Pos[]={m_nPulseX,m_nPulseY,m_nPulseZ,m_nPulseW,m_nPulseU,m_nPulseV};         

	long Add[]={m_nAddX,m_nAddY,m_nAddZ,m_nAddZ,m_nAddU,m_nAddV};                    

	long Ratio[]={m_nRatioX,m_nRatioY,m_nRatioZ,m_nRatioW,m_nRatioU,m_nRatioV};      

	if((m_nAddMode==0)||(m_nAddMode==1))
	{
	//X-Y axis for continuous interpolation
		if(m_bX && m_bY && !m_bZ && !m_bW && !m_bU && !m_bV)
		{
			no=1;
		}		
		else 
		{
			MessageBox("pleade choose X-Y axis!");
			
			return;
		}	
		
		g_WorkStatus=1;
		
		g_CtrlCard.Setup_Speed(1,startv[0],Speed[0],Add[0],Dec[0],Ratio[0],m_nAddMode);
		
		
        //acceleration/deceleration action
		if(startv[0]<=Speed[0])

		{   
			//1 mean manual deceleration,only manual deceleration is allow
			g_CtrlCard.Set_DecMode(1,0,1);
			
			g_CtrlCard.Set_DecPos(1,Pos[0],startv[0],Speed[0],Add[0]);
		}
		
	    //disable decelerate interpolation 
		g_CtrlCard.ForbidDec(no);

        //---------------part 1-------------------
		g_CtrlCard.Interp_Move2(1,Pos[0],Pos[1]);		
		
		
		while(true)
		{   
			DoEvent();
			
			g_CtrlCard.Get_ErrorInf(1,status1);
			
			if(status1!=0 || g_WorkStatus==0)
				goto err;
			
			//status2:  0:disable write    1enable write
			g_CtrlCard.Get_AllowInpStatus(no,status2);
			
			if(status2!=0)break;
			
		}
		//----------------part 2------------------
		g_CtrlCard.Interp_Move2(1,Pos[0],Pos[1]);				
		
		while(true)
		{   
			DoEvent();
			
			g_CtrlCard.Get_ErrorInf(1,status1);
			
			if(status1!=0 || g_WorkStatus==0) 
				goto err;

			//status2:    0:disable write    1enable write
			g_CtrlCard.Get_AllowInpStatus(no,status2);
			
			if(status2!=0)
				break;
		}
		
		//-----------------part 3-----------------
		g_CtrlCard.Interp_Move2(1,Pos[0],Pos[1]);	
		while(true)
		{   
			DoEvent();
			
			g_CtrlCard.Get_ErrorInf(1,status1);
			
			if(status1!=0 || g_WorkStatus==0)goto err;
			
			g_CtrlCard.Get_AllowInpStatus(no,status2);
			
			if(status2!=0)break;
		}

         //-----------------last part-----------------
		g_CtrlCard.AllowDec(no);//enable decelerate interpolation			
		
		
		g_CtrlCard.Interp_Move2(1,Pos[0],Pos[1]);
		while(true)
		{   
			DoEvent();
			g_CtrlCard.Get_ErrorInf(1,status1);

			if(status1!=0 || g_WorkStatus==0) //g_WorkStatus:while stopping report error
				goto err;
			
			g_CtrlCard.Get_Status(no,status2,1);
			if(status2==0)break;
		}
		
		g_WorkStatus=0;
		
		return;
		
err:
		MessageBox("error!");
		return; 
	}
	else
	{
		MessageBox("can't choose S-curve for add or edc type !");
	}	
}

/**********************************************************

OnButtonCmove():continuous move button

**********************************************************/
void CDEMODlg::OnButtonCmove() 
{
	UpdateData(TRUE);
	
	long Startv[]={m_nStartvX,m_nStartvY,m_nStartvZ,m_nStartvW,m_nStartvU ,m_nStartvV}; 
	
	long Speed[]={m_nSpeedX,m_nSpeedY,m_nSpeedZ,m_nSpeedW,m_nSpeedU,m_nSpeedV};         
	
	long Dec[]  ={m_nDecX,m_nDecY,m_nDecZ,m_nDecW,m_nDecU,m_nDecV};                    
	
	long Add[]  ={m_nAddX,m_nAddY,m_nAddZ,m_nAddW,m_nAddU,m_nAddV};                   	
	
	long Ratio[]={m_nRatioX,m_nRatioY,m_nRatioZ,m_nRatioW,m_nRatioU,m_nRatioV};         

	if(!m_bX&&!m_bY&&!m_bZ&&!m_bW&&!m_bU&&!m_bV)
	{
		MessageBox("Please choose axis!");
		return ;
	}
	if(m_bX)   
	{	
		g_CtrlCard.Setup_Speed(1, m_nStartvX, m_nSpeedX, m_nAddX, m_nDecX, m_nRatioX, m_nAddMode);
	    
		/**************************************************/
		//continuous move need to judge motion direction   //
		/**************************************************/
		g_CtrlCard.Axis_Cmove(1,m_nPulseX>0?0:1);
	}	
	if(m_bY)
	{
		g_CtrlCard.Setup_Speed(2, m_nStartvY, m_nSpeedY, m_nAddY, m_nDecY, m_nRatioY, m_nAddMode);
		
		g_CtrlCard.Axis_Cmove(2,m_nPulseY>0?0:1);
	}
	if(m_bZ)
	{
		g_CtrlCard.Setup_Speed(3, m_nStartvZ, m_nSpeedZ, m_nAddZ, m_nDecZ, m_nRatioZ, m_nAddMode);
		
		g_CtrlCard.Axis_Cmove(3,m_nPulseZ>0?0:1);					
	}
	if(m_bW)
	{
		g_CtrlCard.Setup_Speed(4, m_nStartvW, m_nSpeedW, m_nAddW, m_nDecW, m_nRatioW, m_nAddMode);
		
		g_CtrlCard.Axis_Cmove(4,m_nPulseW>0?0:1);
	}
			
	if(m_bU)
	{
		g_CtrlCard.Setup_Speed(5, m_nStartvU, m_nSpeedU, m_nAddU, m_nDecU, m_nRatioU, m_nAddMode);
		
		g_CtrlCard.Axis_Cmove(5,m_nPulseU>0?0:1);
	}

	if(m_bV)
	{
		g_CtrlCard.Setup_Speed(6, m_nStartvV, m_nSpeedV, m_nAddV, m_nDecV, m_nRatioV, m_nAddMode);
		
		g_CtrlCard.Axis_Cmove(6,m_nPulseV>0?0:1);
	}
}
	
/******************************************************

OnDestroy() :to quit interface and release motion control card

*******************************************************/

void CDEMODlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	g_CtrlCard.End_Board();//release motion-card
}
